/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.topicmaps;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.Topic;
import systems.dmx.core.model.topicmaps.ViewAssoc;
import systems.dmx.core.model.topicmaps.ViewTopic;
import systems.dmx.core.service.websocket.WebSocketService;

class Messenger {
    private WebSocketService wss;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    Messenger(WebSocketService wss) {
        this.wss = wss;
    }

    void newTopicmap(Topic topicmapTopic) {
        try {
            this.sendToReadAllowed(new JSONObject().put("type", (Object)"newTopicmap").put("args", (Object)new JSONObject().put("topicmapTopic", (Object)topicmapTopic.toJSON())), topicmapTopic.getId());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error while sending a \"newTopicmap\" message:", e);
        }
    }

    void addTopicToTopicmap(long topicmapId, ViewTopic topic) {
        try {
            this.sendToReadAllowed(new JSONObject().put("type", (Object)"addTopicToTopicmap").put("args", (Object)new JSONObject().put("topicmapId", topicmapId).put("viewTopic", (Object)topic.toJSON())), topic.getId());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error while sending a \"addTopicToTopicmap\" message:", e);
        }
    }

    void addAssocToTopicmap(long topicmapId, ViewAssoc assoc) {
        try {
            this.sendToReadAllowed(new JSONObject().put("type", (Object)"addAssocToTopicmap").put("args", (Object)new JSONObject().put("topicmapId", topicmapId).put("viewAssoc", (Object)assoc.toJSON())), assoc.getId());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error while sending a \"addAssocToTopicmap\" message:", e);
        }
    }

    void setTopicPosition(long topicmapId, long topicId, int x, int y) {
        try {
            this.sendToAllButOrigin(new JSONObject().put("type", (Object)"setTopicPosition").put("args", (Object)new JSONObject().put("topicmapId", topicmapId).put("topicId", topicId).put("pos", (Object)new JSONObject().put("x", x).put("y", y))));
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error while sending a \"setTopicPosition\" message:", e);
        }
    }

    void setTopicVisibility(long topicmapId, long topicId, boolean visibility) {
        try {
            this.sendToAllButOrigin(new JSONObject().put("type", (Object)"setTopicVisibility").put("args", (Object)new JSONObject().put("topicmapId", topicmapId).put("topicId", topicId).put("visibility", visibility)));
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error while sending a \"setTopicVisibility\" message:", e);
        }
    }

    void setAssocVisibility(long topicmapId, long assocId, boolean visibility) {
        try {
            this.sendToAllButOrigin(new JSONObject().put("type", (Object)"setAssocVisibility").put("args", (Object)new JSONObject().put("topicmapId", topicmapId).put("assocId", assocId).put("visibility", visibility)));
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error while sending a \"setAssocVisibility\" message:", e);
        }
    }

    private void sendToAllButOrigin(JSONObject message) {
        this.wss.sendToAllButOrigin(message.toString());
    }

    private void sendToReadAllowed(JSONObject message, long objectId) {
        this.wss.sendToReadAllowed(message.toString(), objectId);
    }
}

