/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.webservice.provider;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.osgi.CoreActivator;
import systems.dmx.core.util.JavaUtils;

@Provider
public class ObjectProvider
implements MessageBodyReader<Object> {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return (this.getFactoryMethod(type) != null || this.getJSONConstructor(type) != null) && mediaType.isCompatible(MediaType.APPLICATION_JSON_TYPE);
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            JSONObject json = new JSONObject(JavaUtils.readText((InputStream)entityStream));
            Method method = this.getFactoryMethod(type);
            if (method != null) {
                return method.invoke((Object)CoreActivator.getModelFactory(), json);
            }
            return this.getJSONConstructor(type).newInstance(json);
        }
        catch (Exception e) {
            throw new RuntimeException("Deserializing a " + type.getName() + " failed", e);
        }
    }

    private Method getFactoryMethod(Class<?> type) {
        try {
            String methodName = "new" + type.getSimpleName();
            return CoreActivator.getModelFactory().getClass().getDeclaredMethod(methodName, JSONObject.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Constructor<?> getJSONConstructor(Class<?> type) {
        try {
            return type.getDeclaredConstructor(JSONObject.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

