/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.impl;

import java.util.Iterator;
import systems.dmx.core.impl.DMXObjectModelImpl;

class ReadableIterable<M extends DMXObjectModelImpl>
implements Iterable<M> {
    private Iterable<M> models;

    ReadableIterable(Iterable<M> models) {
        this.models = models;
    }

    @Override
    public Iterator<M> iterator() {
        return new ReadableIterator();
    }

    private class ReadableIterator
    implements Iterator<M> {
        private Iterator<M> i;
        private M next;

        private ReadableIterator() {
            this.i = ReadableIterable.this.models.iterator();
        }

        @Override
        public boolean hasNext() {
            this.findNext();
            return this.next != null;
        }

        @Override
        public M next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void findNext() {
            this.next = null;
            while (this.i.hasNext() && this.next == null) {
                DMXObjectModelImpl model = (DMXObjectModelImpl)this.i.next();
                if (!model.isReadable()) continue;
                this.next = model;
            }
        }
    }
}

