/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.core.service.accesscontrol;

import com.sun.jersey.core.util.Base64;
import org.codehaus.jettison.json.JSONObject;

public class Credentials {
    public String username;
    public String password;
    public String methodName;

    public Credentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public Credentials(JSONObject cred) {
        try {
            this.username = cred.getString("username");
            this.password = cred.getString("password");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal credentials: " + cred, e);
        }
    }

    public Credentials(String authHeader) {
        String[] splitted = authHeader.split("\\s+");
        if (splitted.length != 2) {
            throw new IllegalArgumentException("Illegal Authorization header: \"" + authHeader + "\"");
        }
        String method = splitted[0];
        String userAndPassword = splitted[1];
        String[] values = new String(Base64.base64Decode((String)userAndPassword)).split(":");
        String username = values.length > 0 ? values[0] : "";
        String password = values.length > 1 ? values[1] : "";
        this.username = username;
        this.password = password;
        this.methodName = method;
    }

    public String toString() {
        return "username=\"" + this.username + "\", password=\"" + this.password + "\"";
    }
}

