/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebEvent {
    private static final String TOPIC_WEB_EVENT = "org/osgi/service/web";
    private static final String TOPIC_DEPLOYING = "org/osgi/service/web/DEPLOYING";
    private static final String TOPIC_DEPLOYED = "org/osgi/service/web/DEPLOYED";
    private static final String TOPIC_UNDEPLOYING = "org/osgi/service/web/UNDEPLOYING";
    private static final String TOPIC_UNDEPLOYED = "org/osgi/service/web/UNDEPLOYED";
    private static final String TOPIC_FAILED = "org/osgi/service/web/FAILED";
    private static final String CONTEXT_PATH = "context.path";
    private static final String EXCEPTION = "exception";
    private static final String COLLISION = "collision";
    private static final String COLLISION_BUNDLES = "collision.bundles";
    private static final String EXTENDER_BUNDLE = "extender.bundle";
    private static final String EXTENDER_BUNDLE_ID = "extender.bundle.id";
    private static final String EXTENDER_BUNDLE_VERSION = "extender.bundle.version";
    private static final String EXTENDER_BUNDLE_SYMBOLICNAME = "extender.bundle.symbolicName";
    private static final String HEADER_WEB_CONTEXT_PATH = "Web-ContextPath";

    static Event DEPLOYING(Bundle webAppBundle, Bundle extenderBundle) {
        return new Event(TOPIC_DEPLOYING, WebEvent.createBaseProperties(webAppBundle, extenderBundle));
    }

    static Event DEPLOYED(Bundle webAppBundle, Bundle extenderBundle) {
        return new Event(TOPIC_DEPLOYED, WebEvent.createBaseProperties(webAppBundle, extenderBundle));
    }

    static Event UNDEPLOYING(Bundle webAppBundle, Bundle extenderBundle) {
        return new Event(TOPIC_UNDEPLOYING, WebEvent.createBaseProperties(webAppBundle, extenderBundle));
    }

    static Event UNDEPLOYED(Bundle webAppBundle, Bundle extenderBundle) {
        return new Event(TOPIC_UNDEPLOYED, WebEvent.createBaseProperties(webAppBundle, extenderBundle));
    }

    static Event FAILED(Bundle webAppBundle, Bundle extenderBundle, Throwable exception, String collision, Long collisionBundles) {
        Dictionary<String, Object> props = WebEvent.createBaseProperties(webAppBundle, extenderBundle);
        if (exception != null) {
            props.put(EXCEPTION, exception);
        }
        if (collision != null) {
            props.put(COLLISION, collision);
        }
        if (collisionBundles != null) {
            props.put(COLLISION_BUNDLES, collisionBundles);
        }
        return new Event(TOPIC_FAILED, props);
    }

    private static Dictionary<String, Object> createBaseProperties(Bundle webAppBundle, Bundle extenderBundle) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("bundle.symbolicName", webAppBundle.getSymbolicName());
        ((Dictionary)props).put("bundle.id", webAppBundle.getBundleId());
        ((Dictionary)props).put("bundle", webAppBundle);
        ((Dictionary)props).put("bundle.version", webAppBundle.getVersion());
        ((Dictionary)props).put(CONTEXT_PATH, webAppBundle.getHeaders().get(HEADER_WEB_CONTEXT_PATH));
        ((Dictionary)props).put("timestamp", System.currentTimeMillis());
        ((Dictionary)props).put(EXTENDER_BUNDLE, extenderBundle);
        ((Dictionary)props).put(EXTENDER_BUNDLE_ID, extenderBundle.getBundleId());
        ((Dictionary)props).put(EXTENDER_BUNDLE_SYMBOLICNAME, extenderBundle.getSymbolicName());
        ((Dictionary)props).put(EXTENDER_BUNDLE_VERSION, extenderBundle.getVersion());
        return props;
    }
}

