/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.files.UploadedFile;
import systems.dmx.linqa.ImageInputStream;

public class ImageScaler {
    private static final int MAX_IMAGE_SIZE = 1024;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public UploadedFile scale(UploadedFile originalImage) {
        try {
            originalImage.setBuffered();
            InputStream in = originalImage.getInputStream();
            BufferedImage image = ImageIO.read(in);
            if (image == null) {
                throw new RuntimeException("Original image could not be read/decoded");
            }
            in.reset();
            int width = image.getWidth();
            int height = image.getHeight();
            int max = Math.max(width, height);
            if (max <= 1024) {
                this.logger.info("Size " + width + "x" + height + " (no scaling needed)");
                return null;
            }
            float scale = 1024.0f / (float)max;
            int targetWidth = (int)((float)width * scale);
            int targetHeight = (int)((float)height * scale);
            this.logger.info("Original " + width + "x" + height + " -> " + targetWidth + "x" + targetHeight + " (scale=" + scale + ")");
            BufferedImage scaledImage = this.createScaledImage(image, targetWidth, targetHeight);
            return this.outputScaledImage(scaledImage, originalImage.getName());
        }
        catch (Exception e) {
            throw new RuntimeException("ImageScaler failed", e);
        }
    }

    private BufferedImage createScaledImage(BufferedImage image, int width, int height) {
        BufferedImage scaledImage = new BufferedImage(width, height, 1);
        Graphics2D g = scaledImage.createGraphics();
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return scaledImage;
    }

    private UploadedFile outputScaledImage(BufferedImage image, String filename) {
        try {
            String basename = JavaUtils.getBasename((String)filename);
            String format = JavaUtils.getExtension((String)filename);
            String scaledFilename = basename + "-" + 1024 + "." + format;
            return new ImageInputStream(image, format, scaledFilename).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Output image failed", e);
        }
    }
}

