/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.linqa;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.Topic;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.service.websocket.WebSocketService;

class Messenger {
    private WebSocketService wss;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    Messenger(WebSocketService wss) {
        this.wss = wss;
    }

    void addComment(long workspaceId, Topic comment) {
        try {
            this.sendToAllButOrigin(new JSONObject().put("type", (Object)"addComment").put("args", (Object)new JSONObject().put("workspaceId", workspaceId).put("comment", (Object)comment.toJSON())));
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error while sending a \"addComment\" message:", e);
        }
    }

    void setViewProps(long topicmapId, long topicId, ViewProps viewProps) {
        try {
            this.sendToReadAllowed(new JSONObject().put("type", (Object)"setViewProps").put("args", (Object)new JSONObject().put("topicmapId", topicmapId).put("topicId", topicId).put("viewProps", (Object)viewProps.toJSON())), topicId);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error while sending a \"setViewProps\" message:", e);
        }
    }

    private void sendToAllButOrigin(JSONObject message) {
        this.wss.sendToAllButOrigin(message.toString());
    }

    private void sendToReadAllowed(JSONObject message, long objectId) {
        this.wss.sendToReadAllowed(message.toString(), objectId);
    }
}

